const express = require("express");
const router = express.Router();
var staffMiddleware = require("../middleware/staff.middleware")
var authMiddleware = require("../middleware/staffAuth.middleware.js")
const researchLibraryController = require("../controllers/researchLibrary");

router.get("/view", researchLibraryController.viewResearch);
router.post("/create-otp/:num", authMiddleware,researchLibraryController.generateCafeOTP);
router.post("/verify-otp", authMiddleware,researchLibraryController.verifyCode);
router.delete("/:id", researchLibraryController.deleteCafeOTP);
router.get("/view-inner", researchLibraryController.viewResearchInner);
router.get("/download/:project_id", researchLibraryController.downloadProject);
router.get("/search", researchLibraryController.searchResearch);
router.get("/view/:department_id", researchLibraryController.viewReasearchByDepartment);

module.exports = router;
 