const express = require("express");
const router = express.Router();
const paymentReportController = require('../../controllers/admin/paymentController')
const upload = require("../../helpers/upload");

router.get('/paymentreport/:session_id', paymentReportController.paymentReport);
router.get('/download-paymentreport/:session_id', paymentReportController.downloadPaymentReport);
router.get('/payment-audit/:session_id', paymentReportController.paymentAudit);
router.get('/binding-payment/:session_id', paymentReportController.bindingPaymentReport);
router.get('/binding-odfel/', paymentReportController.bindingOdfel);
router.post('/binding-update', paymentReportController.upateBindingStatus);
router.post('/create-group', paymentReportController.createGroup);
router.post('/create-bulk-group', upload.single("file"),   paymentReportController.groupBulkUpload);
router.get('/binding-record/:session_id', paymentReportController.bindingRecord);
router.get('/binding-group', paymentReportController.bindingRecordGroup);
router.get('/paymentrequery', paymentReportController.paymentRequery);
router.get('/paymentswap', paymentReportController.paymentSwap);
router.post('/swappayment', paymentReportController.SwapPayment);
router.post('/transaction/verify', paymentReportController.verifyPayment);
router.post('/binding-transaction/verify', paymentReportController.verifyPaymentBinding);
router.post('/payment/swap', paymentReportController.SwapPayment);
router.post('/payment/swapSub', paymentReportController.SwapPaymentSubcription);

module.exports = router;
