const jwt = require("jsonwebtoken");
const User = require("../../models").users;
const Role = require("../../models").roles;

const student = async (req, res, next) => {
  try {
    const userRole = await Role.findOne({
      where: {
        active: 1, //1 Active
        id: 7, //7 student
      },
    });

    if (req.user.role != userRole.id) {
      return res.render("login/student.ejs", {
        error: {
          statusCode: "401",
          success: false,
          message: "Error",
          error: `You are not authorised to have access to student dashboard`,
        },
        success: {
          statusCode: "200",
          success: false,
          message: undefined,
        },
      });
    }
    next();
  } catch (e) {
    console.log(e);
    return res.render("login/student.ejs", {
      error: {
        statusCode: "401",
        success: false,
        message: "Error",
        error: e.message,
      },
      success: {
        statusCode: "200",
        success: false,
        message: undefined,
      },
    });
  }
};

module.exports = student;
