const jwt = require('jsonwebtoken')
const User = require("../../models").users
const Role = require("../../models").roles
const PaymentLogs = require("../../models").payment_logs
const Packages = require("../../models").packages

const verify = async (req, res, next) => {
    if(req.user.first_login == false)
    return res.redirect("/user/get-started")
    try {
        const payment_verify = await User.findOne({
            where:{
                username:req.user.username, 
                payment_status: "PAID"
            }
        })

        if(!payment_verify){
            return res.render("student/student_dashboard.ejs", {
                user: req.user,
                subscriptions: req.subscriptions,
                error: {
                    statusCode: "409",
                    success: false,
                    message: "Error",
                    error: `You can't access some CORASS features, if you haven't pay access fee`
                }
            })   
        }


       next()
       
    } catch (e) {
        return res.render("login/student.ejs", {
            error: {
                statusCode: "401",
                success: false,
                message: "Error",
                error: e.message
            }
        })  
    }

}

module.exports = verify