const axios = require('axios')
const {
    response
} = require('express')
const PaystackDetails = require("../../models").paystack_details

var paystackInfo =  PaystackDetails.findOne({
    where: {
        id: 1
    }
})


const customPaystackAxios = axios.create({
    baseURL: 'https://api.paystack.co',
    headers: {
        'Accept': 'application/json',
    }
})

const requestHandler = request => {
    request.headers.Authorization = `Bearer ${paystackInfo.SECRET_KEY}`

    return request;
}

const responseHandler = response => {
    return response
}

const errorHandler = error => {
    return Promise.reject(error)
}

customPaystackAxios.interceptors.request.use(
    console.log('Request was sent'),
    (request) => requestHandler(request),
    (error) => errorHandler(error)
)

customPaystackAxios.interceptors.response.use(
    console.log('Response received'),
    (response) => responseHandler(response),
    (error) => errorHandler(error)
)

module.exports = customPaystackAxios