const multer = require("multer");
var storage;
const excelFilter = (req, file, cb) => {

  if (
    file.mimetype.includes("application/msword") ||
    file.mimetype.includes("application/pdf") ||
    file.mimetype.includes("application/vnd.openxmlformats-officedocument.wordprocessingml.document")
  ) {
    cb(null, true);
  } else {
    cb("Only DOC or PDF is accepted", false);
  }
};
storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "./project/final");
  },
  filename: (req, file, cb) => {
    console.log(file.originalname);
    cb(null, `${Date.now()}-corass-project-${file.originalname}`);
  },
});
var uploadFile = multer({ storage: storage, fileFilter: excelFilter });
module.exports = uploadFile;

