const { Op } = require("sequelize");

const appendDateFilter = (
  startDate,
  endDate,
  sequelize,
  table = "shipping"
) => {
  try {
    if (startDate && endDate) {
    return {
      [Op.and]: [
        sequelize.where(
          sequelize.fn("date", sequelize.col(`${table}.createdAt`)),
          ">=",
          startDate
        ),
        sequelize.where(
          sequelize.fn("date", sequelize.col(`${table}.createdAt`)),
          "<=",
          endDate
        ),
      ],
    };
  }

  return {};
  } catch (error) {
    throw new Error(error)
  }
};

module.exports = appendDateFilter;
