const ProjectTopic = require("../../models").project_topics

const SchoolSessions = require("../../models").sessions;
const Op = require("sequelize").Op;

exports.Submit = async (req, res) => {
    try {
        const {
            projectType,
            projectTopics,
            user_id,
            lecturer_id,
            cbo_username,
            cbo_otp
        } = req.body;
        // const checkOtp = await CafeOTP.findOne({where:{username:cbo_username,otp_code:cbo_otp,status:false}});
        // if(!checkOtp)
        // return res.status(200).send({success:false, message:"Invalid Authorization Code"})
        let session_id = ""
        const session = await SchoolSessions.findOne({ where: { status: true } });

        if (session) {
        session_id = session.id;
        }
        projectTopics.forEach(async data => {
            result = await ProjectTopic.create({
                project_type_id: projectType,
                student_user_id: user_id,
                lecturer_user_id: lecturer_id,
                topic: data,
                approval_comment:false,
                active:true,
                session_id
            })
        });
        // await CafeOTP.update({status:true},{where:{username:cbo_username,otp_code:cbo_otp,}})
    return res.status(200).send({success:true})
    } catch (e) {
        console.log(e)
        res.status(500).send({
            statusCode: "500",
            success: false,
            message: "Error",
            error: e.message
        })
    }
}
exports.delete = async (req, res) => {
    const {id} = req.params
    await ProjectTopic.destroy({where:{id}});
    return res.redirect('/topic-submission');
};


