const User = require("../../models").users
const Activity = require("../helpers/activity.helper")
const Token = require("../../models").tokens
const bcrypt = require('bcryptjs');
const restMail = require("../helpers/passwordResetMailer")
const codeGenerator = require("../helpers/codeGenerator.helper")


exports.password = async (req, res) => {
  //used - 1
  //unused - 0
  try {

    const {
      email,
      resetCode,
      PasswordNew,
      ConPasswordNew
    } = req.body

    if (!email) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: 'Email is required'
      })
    }


    if (!resetCode) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: 'Reset code is required'
      })
    }


    if (!PasswordNew) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: 'Password required'
      })
    }


    if (!ConPasswordNew) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: 'Confirm password is required'
      })
    }

    if (PasswordNew != ConPasswordNew) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: 'New password & verify password is not the same'
      })
    }

    var code
    var status
    const user = await User.findOne({
      where: {
        email: email
      }
    })

    if (!user) {
      return res.status(404).send({
        statusCode: "404",
        success: false,
        message: 'Error',
        error: `An account doesn\'t exist with ${email}`
      })
    }

    const verifyToken = await Token.findOne({
      where: {
        user_id: user.id,
        code: resetCode
      }
    })

    if (!verifyToken) {
      return res.status(404).send({
        statusCode: "404",
        success: false,
        message: 'Error',
        error: `${resetCode} is invalid`
      })
    }

    if (verifyToken.used == 1) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: `Reset code is already used`
      })
    }

    const updateTokenData = {
      used: 1
    }
    const updateToken = await Token.update(updateTokenData, {
      where: {
        user_id: user.id,
        code: resetCode
      }
    })


    if (updateToken != 1) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: `An error ocurred, try again`
      })
    }


    const hashedpass = await bcrypt.hash(PasswordNew, 10);

    //Update wallet balance  
    const updatePass = {
      password: hashedpass
    }

    //update pin
    const updateNewPass = await User.update(updatePass, {
      where: {
        email: email
      }
    })

  

  const saveActivity = await Activity("password", "You reset user password", user.username)
    

    if (!updateNewPass) {
      return res.status(409).send({
        statusCode: "409",
        success: false,
        message: 'Error',
        error: 'Unable to reset password, try again'
      })
    }

    if (updateNewPass == 1 && saveActivity) {
      return res.send({
        status: 200,
        success: true,
        message: 'Password successfully changed'
      })
    }

  } catch (e) {
    res.status(500).send({
      statusCode: "500",
      success: false,
      message: "Error",
      error: e.message
    })
  }
}