
const Department = require("../../../models").departments;
const Institute = require("../../../models").institutes;
const CryptoJS = require("crypto-js");

exports.getAllDepartment = async (req, res) => {
    try {
        const departments = await Department.findAll({
            include:[
            {model:Institute}
        ],
        raw:true},
        );
        const institutes = await Institute.findAll({raw:true});

        return res.render("admin/department.ejs", {
            departments,
            user:req.user,
            institutes,
            sessions:req.sessions,
          })
    } catch (error) {
        console.log(error)
        return res.render("admin/department.ejs", {
            departments:[],
            user:req.user,
            sessions:req.sessions,
            institutes:[]
          })
    }
};
exports.getOneDepartment = async (req, res) => {
    try {
        const {department_id} = req.params
        const department = await Department.findOne({
            where:{id:department_id},
            raw:true,
            include:[
                {model:Institute}
            ]
        });
        return res.status(200).send({success:true,department})
    } catch (error) {
        return res.status(500).send({success:false,message:error.message})
    }
};
exports.updateDepartment = async (req, res) => {
    try {
        // const {department_id} = req.params
        const departments = await Department.findAll({raw:true});
        const institutes = await Institute.findAll({raw:true});
        await Department.update({...req.body}, {where:{id:req.body.department_id}})
        return res.redirect("/admin/department")
    } catch (error) {
        return res.redirect("/admin/department")
    }
}
exports.createDepartment = async (req, res) => {
    try {
        const {department_name, project_color, institute_id} = req.body;
        await Department.create({
            name:department_name,
            projet_color:project_color,
            code:project_color,
            institute_id
        });
        return res.redirect("/admin/department")
    } catch (error) {
        console.log(error)
        return res.redirect("/admin/department")
    }
}