const express = require("express");
const path = require("path");
const hbs = require("hbs");
const bodyParser = require("body-parser");
const db = require("./models");
require("dotenv").config();
const routeHandler = require("./src/routes/index");
const cookieSession = require("cookie-session");
const cors = require("cors"); 
const app = express();
app.use(cors());
const partialpath = path.join(__dirname, "./src/views/partials");

app.set("views", "./src/views");
app.set("view engine", "ejs");
hbs.registerPartials(partialpath);

app.use("/", express.static((__dirname = "./public/")));
app.use("/css", express.static((__dirname = "./public/css")));
app.use("/css2", express.static((__dirname = "./public/admin/css")));
app.use("/avatar", express.static((__dirname = "./libaries/avatar")));
app.use("/project", express.static((__dirname = "./project")));
app.use(
  "/student-project",
  express.static((__dirname = "./libaries/projects"))
);
app.use("/js", express.static((__dirname = "./public/js")));
app.use("/js2", express.static((__dirname = "./public/admin/js")));
app.use("/img", express.static((__dirname = "./public/img")));
app.use("/img2", express.static((__dirname = "./public/admin/img")));
app.use("/image", express.static((__dirname = "./public/assets/Image")));
app.use("/vendors", express.static((__dirname = "./public/vendors")));
app.use("/vendors2", express.static((__dirname = "./public/admin/vendors")));
app.use("/assets", express.static((__dirname = "./public/assets")));
// db.sequelize.sync()
//   .then(() => {
//     console.log("Synced db.");
//   })
//   .catch((err) => {
//     console.log("Failed to sync db: " + err.message);
//   })
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(express.json());

app.use(
  cookieSession({
    name: "session",
    keys: [process.env.SESSION_SECRET],
    maxAge: 24 * 60 * 60 * 1000,
  })
);

routeHandler(app);

const port = process.env.PORT || 4000;

app.listen(port, () => console.log("listening to port " + port));