if (document.getElementById("veridyPay")) {
  document.getElementById("veridyPay").addEventListener("click", verifyPaymentRef);
}
if (document.getElementById("veridyPayBinding")) {
  document.getElementById("veridyPayBinding").addEventListener("click", verifyPaymentRefBinding);
}

if (document.getElementById("fetchPackage")) {
  document.getElementById("fetchPackage").addEventListener("click", fetchPackage);
}

// if (document.getElementById("changePackage")) {
//   document.getElementById("changePackage").addEventListener("click", changePackage);
// }

function fetchPackage() {

  const matricNumber = document.getElementById("matricNumber").value
  
  document.getElementById("fetchPackage").innerHTML = "Fetching..."
  document.getElementById("fetchPackage").disabled = true
  jQuery.ajax({
    url: `/admin/payment/swap`,
    method: 'POST',
    data: {
      matricNumber:matricNumber
    },
    error: function (request, error) {
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );

      document.getElementById("fetchPackage").innerHTML = "Fetch Package"
      document.getElementById("fetchPackage").disabled = false
      
    },
    success: function (data) {
      document.getElementById("fetchPackage").innerHTML = "Fetch Package"
      document.getElementById("fetchPackage").disabled = false
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }
      if (data.success === true) {
         window.location.href = data.url
      }

    }
  });
}

function verifyPaymentRef() {

  const payref = document.getElementById("payref").value
  
  document.getElementById("veridyPay").innerHTML = "Verifying..."
  document.getElementById("veridyPay").disabled = true
  jQuery.ajax({
    url: `/admin/transaction/verify`,
    method: 'POST',
    data: {
      reference: payref
    },
    error: function (request, error) {
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );

      document.getElementById("veridyPay").innerHTML = "Verify"
      document.getElementById("veridyPay").disabled = false
      
    },
    success: function (data) {
      document.getElementById("veridyPay").innerHTML = "Verify"
      document.getElementById("veridyPay").disabled = false
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }
      if (data.success === true) {
        window.alert(data.message)
        toastr.options.progressBar = true;
        toastr.info(
          `Transaction status: ${data.message}`,
          "MESSAGE", {
            timeOut: 9000
          }
        );
      }

    }
  });
}
function verifyPaymentRefBinding() {

  const payref = document.getElementById("payref").value
  
  document.getElementById("veridyPayBinding").innerHTML = "Verifying..."
  document.getElementById("veridyPayBinding").disabled = true
  jQuery.ajax({
    url: `/admin/binding-transaction/verify`,
    method: 'POST',
    data: {
      reference: payref
    },
    error: function (request, error) {
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );

      document.getElementById("veridyPayBinding").innerHTML = "Verify"
      document.getElementById("veridyPayBinding").disabled = false
      
    },
    success: function (data) {
      document.getElementById("veridyPayBinding").innerHTML = "Verify"
      document.getElementById("veridyPayBinding").disabled = false
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }
      if (data.success === true) {
        window.alert(data.message)
        toastr.options.progressBar = true;
        toastr.info(
          `Transaction status: ${data.message}`,
          "MESSAGE", {
            timeOut: 9000
          }
        );
      }

    }
  });
}

function changePackage(package_id, user_id,sub_id) {

  // const matricNumber = document.getElementById("matricNumber").value
  
  // document.getElementById("fetchPackage").innerHTML = "Fetching..."
  // document.getElementById("fetchPackage").disabled = true
  jQuery.ajax({
    url: `/admin/payment/swapSub`,
    method: 'POST',
    data: {
      package_id,
      user_id,
      sub_id
    },
    error: function (request, error) {
      toastr.options.progressBar = true;
      toastr.error(
        error,
        "ERROR", {
          timeOut: 9000
        }
      );

      // document.getElementById("fetchPackage").innerHTML = "Fetch Package"
      // document.getElementById("fetchPackage").disabled = false
      
    },
    success: function (data) {
      // document.getElementById("fetchPackage").innerHTML = "Fetch Package"
      // document.getElementById("fetchPackage").disabled = false
      if (data.success === false) {
        toastr.options.progressBar = true;
        toastr.error(
          data.error,
          "ERROR", {
            timeOut: 9000
          }
        );
      }
      if (data.success === true) {
        toastr.options.progressBar = true;
        toastr.success(
          `${data.message}`,
          "MESSAGE", {
            timeOut: 9000
          }
        );
      }

    }
  });
}