const { INTEGER } = require("sequelize");
const Sequelize = require("sequelize");
module.exports = function (sequelize, DataTypes) {
  return sequelize.define("users", {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4,
    },
    username: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    second_role: {
      type: DataTypes.INTEGER,
    },
    email: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    phone: {
      type: DataTypes.STRING(191),
      allowNull: true,
    },
    slug: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    password: {
      type: DataTypes.STRING(191),
      allowNull: false,
    },
    uuid: {
      type: DataTypes.STRING(191),
      allowNull: true,
      defaultValue: DataTypes.UUID4,
    },
    email_verified_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    session_id: {
      type: DataTypes.UUID,
      allowNull: true,
    },
    active: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 0,
    },
    group_id: {
      type: DataTypes.UUID,
    },
    has_group: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 0,
    },
    role: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: null,
    },
    first_login: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    remember_token: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    payment_status: {
      type: DataTypes.STRING,
      defaultValue: "UNPAID",
    },
    ppo_paid: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
    },
    ppo_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    is_printed:{
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
  });
  users.init(
    {
      role: DataTypes.STRING,
    },
    {
      sequelize,
      modelName: "users",
    }
  );
  return users;
};
