const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('user_agents', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    device: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    browser: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    browser_version: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    platform: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    platform_version: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    ip: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    country: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    country_code: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    region: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    region_code: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    city: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    area_code: {
      type: DataTypes.STRING(5),
      allowNull: true
    },
    latitude: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    longitude: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    active: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 1
    },
    last_activity_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    last_url_visited: {
      type: DataTypes.STRING(191),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'user_agents',
    timestamps: true
  });
};
