const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tokens', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    code: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    used: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 0
    },
    purpose: {
      type: DataTypes.STRING(191),
      allowNull: false,
      defaultValue: "Activate account"
    }
  }, {
    sequelize,
    tableName: 'tokens',
    timestamps: true
  });
};
