const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('student_supervisors', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    project_type_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    student_user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    lecturer_user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    session_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    approval_stage: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 1
    },
    approval_comment: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    active: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 1
    }
  }, {
    sequelize,
    tableName: 'student_supervisors',
    timestamps: true
  });
};
