const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('split_accounts', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    alias: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    percentage: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    amount: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: true
    },
    description: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    isPrimary: {
      type: DataTypes.STRING(191),
      allowNull: false,
      defaultValue: "0"
    }
  }, {
    sequelize,
    tableName: 'split_accounts',
    timestamps: true
  });
};
