const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('school_settings', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    name: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    address: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    logo: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    welcome_logo: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    background_image: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    favicon: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    base_demography: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    app_name: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    app_description: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    app_welcome_note: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    student_id_label: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    student_id_placeholder: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    staff_id_label: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    staff_id_placeholder: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    use_flat_fee: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0
    },
    flat_fee: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: false,
      defaultValue: 2000.00
    },
    percentage: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: false,
      defaultValue: 0.30
    },
    deduction_from_source: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 0
    },
    txn_processing_fee: {
      type: DataTypes.STRING(18),
      allowNull: false,
      defaultValue: "0"
    }
  }, {
    sequelize,
    tableName: 'school_settings',
    timestamps: true
  });
};
