const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('project_submissions', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    project_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    document_category_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    document_path: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    slug: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    session_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    ppo_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    is_approved: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 0
    },
    ppo_paid: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0
    },
    approval_comment: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    active: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 1
    }
  }, {
    sequelize,
    tableName: 'project_submissions',
    timestamps: true
  });
};
