const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('profiles', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    second_role: {
      type: DataTypes.INTEGER
    },
    department_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    session_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    role_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    level_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    study_mode_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    firstname: {
      type: DataTypes.STRING(100),
    },
    lastname: {
      type: DataTypes.STRING(100),
    },
    middlename: {
      type: DataTypes.STRING(100),
    },
    photo_path: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    gender: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    title: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: ""
    },
    receipt_number:{
      type:DataTypes.STRING(100),
    }
  }, {
    sequelize,
    tableName: 'profiles',
    timestamps: true
  });
};
