const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
    return sequelize.define('paystack_details', {
        id: {
            allowNull: false,
            primaryKey: true,
            type: DataTypes.UUID,
            defaultValue: DataTypes.UUIDV4
        },
        LIVE_SECRET_KEY: {
            type: DataTypes.STRING,
            allowNull: false
        },
        LIVE_PUBLIC_KEY: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TEST_SECRET_KEY: {
            type: DataTypes.STRING,
            allowNull: false
        },
        TEST_PUBLIC_KEY: {
            type: DataTypes.STRING,
            allowNull: false
        },
    }, {
        sequelize,
        tableName: 'paystack_details',
        timestamps: true
    });
};