const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('payment_logs', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    payment_channel_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    package_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    amount: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: false
    },
    txn_ref: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    txn_desc: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    txn_status: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    external_payment_ref: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    external_payment_status: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    external_payment_comment: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    external_card_number: {
      type: DataTypes.STRING(10),
      allowNull: true
    },
    external_retrieval_ref: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    external_response_code: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    split_accounts: {
      type: DataTypes.TEXT,
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'payment_logs',
    timestamps: true
  });
};
