
const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('payment_history', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    username: {
      type: DataTypes.STRING,
      allowNull: false
    },
    amount: {
      type: DataTypes.DECIMAL(18,2),
      allowNull: false
    },
    paystack_event: {
        type: DataTypes.STRING(191),
        allowNull: true
      },
    txn_ref: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    session_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    txn_desc: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    txn_status: {
      type: DataTypes.STRING(191),
      allowNull: false,
      defaultValue: "Pending"
    },
    txn_channel: {
        type: DataTypes.STRING(191),
        allowNull: true
      },
      package_id: {
        type: DataTypes.UUID,
        allowNull: true
      },
    split_accounts: {
      type: DataTypes.TEXT,
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'payment_history',
    timestamps: true
  });
};
