const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('payment_channels', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    channel_name: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    merchant_name: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    merchant_code: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    merchant_logo_path: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    secret_key: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    public_key: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    encryption_key: {
      type: DataTypes.STRING(191),
      allowNull: false
    },
    is_default: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 0
    },
    active: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: 1
    }
  }, {
    sequelize,
    tableName: 'payment_channels',
    timestamps: true
  });
};
