// const Sequelize = require('sequelize');
module.exports = function(sequelize, Sequelize) {
  return sequelize.define('odfel_forms', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: Sequelize.UUID,
      defaultValue: Sequelize.UUIDV4
    },
    username: {
      type: Sequelize.UUID,
      allowNull: false
    },
    amount: {
      type: Sequelize.DECIMAL(18, 2),
      allowNull: false
    },
    topic: {
      type: Sequelize.STRING(),
    },
    photo_path: {
      type: Sequelize.STRING(),
    },
    firstname: {
      type: Sequelize.STRING(),
    },
    lastname: {
      type: Sequelize.STRING(),
    },
    othername: {
      type: Sequelize.STRING(),
    },
    email: {
      type: Sequelize.STRING(),
    },
    phone_number: {
      type: Sequelize.STRING(),
    },
    department: {
      type: Sequelize.STRING(),
    },
    institute: {
      type: Sequelize.STRING(),
    },
    supervisor_name: {
      type: Sequelize.STRING(),
    },
    txn_ref: {
      type: Sequelize.STRING(),
      allowNull: true
    },
    txn_status: {
      type: Sequelize.STRING(),
      allowNull: true,
      defaultValue: "Pending"
    },
    createdAt: {
      allowNull: false,
      type: Sequelize.DATE
    },
    updatedAt: {
      allowNull: false,
      type: Sequelize.DATE
    }
  }, {
    sequelize,
    tableName: 'odfel_forms',
    timestamps: true
  });
};
