const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('library_access_codes', {
    id: {
        allowNull: false,
        primaryKey: true,
        type: DataTypes.UUID,
        defaultValue: Sequelize.UUIDV4
    },
    access_code: {
        type: DataTypes.STRING,
    },
    creator: {
        type: DataTypes.UUID,
    },
    user_by: {
        type: DataTypes.UUID,
    },
    status: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue:false
    },
    createdAt: {
      allowNull: false,
      type: DataTypes.DATE
    },
    updatedAt: {
      allowNull: false,
      type: DataTypes.DATE
    }
  }, {
    sequelize,
    tableName: 'library_access_codes',
    timestamps: true
  });
};
