var DataTypes = require("sequelize").DataTypes;
var _activity_log = require("./activity_log");
var _departments = require("./departments");
var _device_tokens = require("./device_tokens");
var _document_categories = require("./document_categories");
var _failed_jobs = require("./failed_jobs");
var _firebase_settings = require("./firebase_settings");
var _institutes = require("./institutes");
var _jobs = require("./jobs");
var _levels = require("./levels");
var _migrations = require("./migrations");
var _model_has_permissions = require("./model_has_permissions");
var _model_has_roles = require("./model_has_roles");
var _notifications = require("./notifications");
var _packages = require("./packages");
var _password_resets = require("./password_resets");
var _payment_channels = require("./payment_channels");
var _payment_logs = require("./payment_logs");
var _permission_groups = require("./permission_groups");
var _permissions = require("./permissions");
var _personal_access_tokens = require("./personal_access_tokens");
var _profiles = require("./profiles");
var _project_submissions = require("./project_submissions");
var _project_topics = require("./project_topics");
var _project_types = require("./project_types");
var _projects = require("./projects");
var _role_has_permissions = require("./role_has_permissions");
var _roles = require("./roles");
var _school_settings = require("./school_settings");
var _siwes = require("./siwes");
var _split_accounts = require("./split_accounts");
var _student_supervisors = require("./student_supervisors");
var _study_modes = require("./study_modes");
var _subscriptions = require("./subscriptions");
var _tokens = require("./tokens");
var _user_agents = require("./user_agents");
var _user_departments = require("./user_departments");
var _users = require("./users");

function initModels(sequelize) {
  var activity_log = _activity_log(sequelize, DataTypes);
  var departments = _departments(sequelize, DataTypes);
  var device_tokens = _device_tokens(sequelize, DataTypes);
  var document_categories = _document_categories(sequelize, DataTypes);
  var failed_jobs = _failed_jobs(sequelize, DataTypes);
  var firebase_settings = _firebase_settings(sequelize, DataTypes);
  var institutes = _institutes(sequelize, DataTypes);
  var jobs = _jobs(sequelize, DataTypes);
  var levels = _levels(sequelize, DataTypes);
  var migrations = _migrations(sequelize, DataTypes);
  var model_has_permissions = _model_has_permissions(sequelize, DataTypes);
  var model_has_roles = _model_has_roles(sequelize, DataTypes);
  var notifications = _notifications(sequelize, DataTypes);
  var packages = _packages(sequelize, DataTypes);
  var password_resets = _password_resets(sequelize, DataTypes);
  var payment_channels = _payment_channels(sequelize, DataTypes);
  var payment_logs = _payment_logs(sequelize, DataTypes);
  var permission_groups = _permission_groups(sequelize, DataTypes);
  var permissions = _permissions(sequelize, DataTypes);
  var personal_access_tokens = _personal_access_tokens(sequelize, DataTypes);
  var profiles = _profiles(sequelize, DataTypes);
  var project_submissions = _project_submissions(sequelize, DataTypes);
  var project_topics = _project_topics(sequelize, DataTypes);
  var project_types = _project_types(sequelize, DataTypes);
  var projects = _projects(sequelize, DataTypes);
  var role_has_permissions = _role_has_permissions(sequelize, DataTypes);
  var roles = _roles(sequelize, DataTypes);
  var school_settings = _school_settings(sequelize, DataTypes);
  var siwes = _siwes(sequelize, DataTypes);
  var split_accounts = _split_accounts(sequelize, DataTypes);
  var student_supervisors = _student_supervisors(sequelize, DataTypes);
  var study_modes = _study_modes(sequelize, DataTypes);
  var subscriptions = _subscriptions(sequelize, DataTypes);
  var tokens = _tokens(sequelize, DataTypes);
  var user_agents = _user_agents(sequelize, DataTypes);
  var user_departments = _user_departments(sequelize, DataTypes);
  var users = _users(sequelize, DataTypes);


  return {
    activity_log,
    departments,
    device_tokens,
    document_categories,
    failed_jobs,
    firebase_settings,
    institutes,
    jobs,
    levels,
    migrations,
    model_has_permissions,
    model_has_roles,
    notifications,
    packages,
    password_resets,
    payment_channels,
    payment_logs,
    permission_groups,
    permissions,
    personal_access_tokens,
    profiles,
    project_submissions,
    project_topics,
    project_types,
    projects,
    role_has_permissions,
    roles,
    school_settings,
    siwes,
    split_accounts,
    student_supervisors,
    study_modes,
    subscriptions,
    tokens,
    user_agents,
    user_departments,
    users,
  };
}
module.exports = initModels;
module.exports.initModels = initModels;
module.exports.default = initModels;
