'use strict';

const fs = require('fs');
const path = require('path');
const Sequelize = require('sequelize');
const process = require('process');
const basename = path.basename(__filename);
const env = process.env.NODE_ENV || 'development';
const db = {};


const sequelize = require("../config/connection");

fs
  .readdirSync(__dirname)
  .filter(file => {
    const files = [
      "paystack_details.js",
      "users.js",
      "activity_log.js",
      "departments.js",
      "device_tokens.js",
      "document_categories.js",
      "failed_jobs.js",
      "firebase_settings.js",
      "institutes.js",
      "jobs.js",
      "levels.js",
      "migrations.js",
      "model_has_permissions.js",
      "model_has_roles.js",
      "notifications.js",
      "packages.js",
      "password_resets.js",
      "payment_channels.js",
      "payment_logs.js",
      "permission_groups.js",
      "permissions.js",
      "personal_access_tokens.js",
      "profiles.js",
      "project_submissions.js",
      "project_topics.js",
      "project_types.js",
      "projects.js",
      "role_has_permissions.js",
      "roles.js",
      "school_settings.js",
      "siwes.js",
      "split_accounts.js",
      "student_supervisors.js",
      "study_modes.js",
      "subscriptions.js",
      "tokens.js",
      "user_agents.js",
      "user_departments.js",
      "sessions.js",
      "user_role.js",
      "payment_history.js",
      "cafe_codes.js",
      "cafe_users.js",
      "cafe_otps.js",
      "library_access_codes.js",
      "binding_payments.js",
      "groups.js",
      "odfel_forms.js",
      "chatbot_message.js",
      "interractions.js"
    ];
    return (
      files.indexOf(file) >= 0 &&
      file.indexOf(".") !== 0 &&
      file !== basename &&
      file.slice(-3) === ".js"
    );
  })
  .forEach(file => {
    const model = require(path.join(__dirname, file))(sequelize, Sequelize.DataTypes);
    db[model.name] = model;
  });

Object.keys(db).forEach(modelName => {
  if (db[modelName].associate) {
    db[modelName].associate(db);
  }
});

db.sequelize = sequelize;
db.Sequelize = Sequelize;

db.binding_payments.belongsTo(db.users, {foreignKey:"user_id"});
db.profiles.belongsTo(db.users, {foreignKey: "user_id",})
db.profiles.belongsTo(db.roles, {foreignKey: "role_id", as: "firstRole"})
db.profiles.belongsTo(db.roles, {foreignKey: "second_role", as: "secondRole"})
db.users.hasOne(db.profiles, {foreignKey: "user_id",})
db.users.belongsTo(db.student_supervisors, {foreignKey: "id",})
db.profiles.belongsTo(db.departments, {foreignKey: "department_id",})
db.profiles.belongsTo(db.levels, {foreignKey: "level_id",})
db.profiles.belongsTo(db.study_modes, {foreignKey: "study_mode_id",})
db.profiles.belongsTo(db.sessions, {foreignKey: "session_id",})
db.project_submissions.belongsTo(db.document_categories, {foreignKey: "document_category_id",})
db.departments.belongsTo(db.institutes, {foreignKey: "institute_id",})
db.profiles.hasMany(db.projects, {foreignKey: "student_user_id",});
db.profiles.hasMany(db.projects, {foreignKey: "lecturer_user_id",});
db.profiles.hasMany(db.project_topics, {foreignKey: "student_user_id",})
db.users.hasMany(db.project_topics, {foreignKey: "student_user_id",})
db.profiles.hasMany(db.project_topics, {foreignKey: "lecturer_user_id",})
db.project_types.hasMany(db.projects, {foreignKey: "lecturer_user_id",})
db.project_types.hasMany(db.project_topics, {foreignKey: "id",})
db.projects.hasMany(db.project_submissions, {foreignKey: "id",})
db.roles.hasMany(db.user_roles, {foreignKey: "id"});
db.users.hasMany(db.user_roles, {foreignKey: "id"});

db.users.belongsTo(db.roles, {foreignKey: "second_role", as: "roles"});

db.user_roles.belongsTo(db.roles,{
    foreignKey: "role_id",
});

db.user_roles.belongsTo(db.users,{
  foreignKey: "user_id",
});

db.projects.belongsTo(db.users,{
  as: "student",
  foreignKey: "student_user_id",
});
db.projects.belongsTo(db.users,{
  as: "lecturer",
  foreignKey: "lecturer_user_id",
});
db.student_supervisors.belongsTo(db.users,{
  as: "student",
  foreignKey: "student_user_id",
});
db.student_supervisors.belongsTo(db.users,{
as: "lecturer",
foreignKey: "lecturer_user_id",
});

db.student_supervisors.belongsTo(db.profiles,{
  as: "stud",
  foreignKey: "student_user_id",
});

db.student_supervisors.belongsTo(db.profiles,{
as: "supervisor",
foreignKey: "lecturer_user_id",
});


db.project_topics.belongsTo(db.users,{
  as: "student",
  foreignKey: "student_user_id",
});
db.project_topics.belongsTo(db.users,{
as: "lecturer",
foreignKey: "lecturer_user_id",
});
db.project_topics.belongsTo(db.project_types,{
  foreignKey: "project_type_id",
});


db.library_access_codes.belongsTo(db.users,{
  as: "createdBy",
  foreignKey: "creator",
});

db.library_access_codes.belongsTo(db.users,{
  as: "usedBy",
  foreignKey: "user_by",
});

db.payment_history.belongsTo(db.packages, {foreignKey:"package_id"});
db.payment_history.belongsTo(db.profiles, {foreignKey:"package_id"});
db.payment_history.belongsTo(db.users, {foreignKey:"username"});
db.binding_payments.belongsTo(db.users, {foreignKey:"user_id"});
// db.profiles.hasOne(db.packages, {foreignKey:"username"});
db.project_submissions.belongsTo(db.projects, {foreignKey:"project_id"});
db.project_submissions.belongsTo(db.project_topics, {foreignKey:"project_id"});
db.project_topics.hasMany(db.project_submissions, {foreignKey:"project_id"});
db.projects.belongsTo(db.project_types, {foreignKey:"project_type_id"});
db.departments.hasMany(db.profiles, {foreignKey: "id",});
db.levels.hasMany(db.profiles, {foreignKey: "id",});
db.study_modes.hasMany(db.profiles, {foreignKey: "id",});
db.institutes.hasMany(db.departments, {foreignKey: "id",});
module.exports = db;
