const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('firebase_settings', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    api_key: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    auth_domain: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    database_url: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    project_id: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    storage_bucket: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    messaging_sender_id: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    app_id: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    measurement_id: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    server_key: {
      type: DataTypes.TEXT,
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'firebase_settings',
    timestamps: true
  });
};
