const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  const ChatbotMessage = sequelize.define('chatbot_message', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    doc_id: {
      type: DataTypes.UUID,
      allowNull: false,

    },
    sender_type: {
      type: DataTypes.ENUM('user', 'assistant'),
      allowNull: false,
      defaultValue: 'user'
    },
    message: {
      type: DataTypes.TEXT,
      allowNull: false
    },
    metadata: {
      type: DataTypes.JSON,
      allowNull: true,
      comment: 'Message metadata like tokens, analysis data, etc.'
    },
    readAt: {
      type: DataTypes.DATE,
      allowNull: true
    },
    createdAt: {
      allowNull: false,
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW
    },
    updatedAt: {
      allowNull: false,
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW
    }
  }, {
    sequelize,
    tableName: 'chatbot_messages',
    timestamps: true,
    indexes: [
      {
        fields: ['doc_id', 'sender_type']
      },
      {
        fields: ['createdAt']
      },
      {
        fields: ['readAt']
      }
    ]
  });


  return ChatbotMessage;
};