const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('cafe_users', {
    id: {
        allowNull: false,
        primaryKey: true,
        type: DataTypes.UUID,
        defaultValue: Sequelize.UUIDV4
    },
    surname: {
        type: DataTypes.STRING,
    },
    firstname: {
        type: DataTypes.STRING,
    },
    othername: {
        type: DataTypes.STRING,
    },
    gender: {
        type: DataTypes.STRING,
    },
    phone_num: {
        type: DataTypes.STRING,
    },
    email: {
        type: DataTypes.STRING,
    },
    home_address: {
        type: DataTypes.STRING,
    },
    marital_status: {
        type: DataTypes.STRING,
    },
    business_name: {
        type: DataTypes.STRING,
    },
    business_location: {
        type: DataTypes.STRING,
    },
    nature_busisness: {
        type: DataTypes.STRING,
    },
    username: {
        type: DataTypes.STRING,
    },
    password: {
        type: DataTypes.STRING,
    },
    auth_code: {
        type: DataTypes.STRING,
    },
    passport_photo: {
        type: DataTypes.STRING,
    },
    token: {
        type: DataTypes.TEXT,
    },
    payment_status: {
        type: DataTypes.STRING,
        defaultValue: "UNPAID"
    },
    createdAt: {
      allowNull: false,
      type: DataTypes.DATE
    },
    updatedAt: {
      allowNull: false,
      type: DataTypes.DATE
    }
  }, {
    sequelize,
    tableName: 'cafe_users',
    timestamps: true
  });
};
