const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('binding_payments', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    user_id: {
      type: DataTypes.UUID,
      allowNull: false
    },
    amount: {
      type: DataTypes.DECIMAL(18, 2),
      allowNull: false
    },
    paystack_event: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    session_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    status: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    txn_ref: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    txn_desc: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    txn_status: {
      type: DataTypes.STRING(191),
      allowNull: true,
      defaultValue: "Pending"
    },
    txn_channel: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    package_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    split_accounts: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    createdAt: {
      allowNull: false,
      type: DataTypes.DATE
    },
    updatedAt: {
      allowNull: false,
      type: DataTypes.DATE
    }
  }, {
    sequelize,
    tableName: 'binding_payments',
    timestamps: true
  });
};
