const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('activity_log', {
    id: {
      allowNull: false,
      primaryKey: true,
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4
    },
    log_name: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: false
    },
    subject_type: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    event: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    subject_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    causer_type: {
      type: DataTypes.STRING(191),
      allowNull: true
    },
    causer_id: {
      type: DataTypes.UUID,
      allowNull: true
    },
    properties: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    batch_uuid: {
      type: DataTypes.CHAR(36),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'activity_log',
    timestamps: true
  });
};
