'use strict';

module.exports = {
  up: async (queryInterface, Sequelize) => {
    await queryInterface.createTable('chatbot_messages', {
      id: {
        allowNull: false,
        primaryKey: true,
        type: Sequelize.UUID,
        defaultValue: Sequelize.UUIDV4
      },
      doc_id: {
        type: Sequelize.UUID,
        allowNull: false,
      },
      sender_type: {
        type: Sequelize.ENUM('user', 'assistant'),
        allowNull: false,
        defaultValue: 'user'
      },
      message: {
        type: Sequelize.TEXT,
        allowNull: false
      },
      metadata: {
        type: Sequelize.JSON,
        allowNull: true,
        comment: 'Message metadata like tokens, analysis data, etc.'
      },
      readAt: {
        type: Sequelize.DATE,
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      },
      updatedAt: {
        allowNull: false,
        type: Sequelize.DATE,
        defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
      }
    });

    // Add indexes
    await queryInterface.addIndex('chatbot_messages', ['doc_id', 'sender_type']);
    await queryInterface.addIndex('chatbot_messages', ['createdAt']);
    await queryInterface.addIndex('chatbot_messages', ['readAt']);
  },

  down: async (queryInterface, Sequelize) => {
    await queryInterface.dropTable('chatbot_messages');
  }
};