const Sequelize = require("sequelize");
const env = process.env.NODE_ENV || "development";
const config = require(`${__dirname}/../config/config.js`)[env];

const logging = env === "development" || env === "staging" ? console.log : false;

const sequelize = new Sequelize(config.RDS_DB_NAME, config.RDS_USERNAME, config.RDS_PASSWORD, {
  dialect: "mysql",
  logging, 
  ...config,
});

sequelize
  .authenticate()
  .then(() => {
    console.log("Connection to database established");
  })
  .catch((err) => {
    console.log(err)
    console.error("Unable to connect to the database:");
  });

module.exports = sequelize;
